*******************************************************************************
*                      68000/68010 Grundprogramm hardcopy                     *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                       Hardcopy- und Maus-Routinen                           *
*******************************************************************************


hardcopy:                       * Ansteuerung der Hardcopy-Maus-Baugruppe
 cmp.b #3, d0                   * Von FarbGDP nicht untersttzt Unterprogramm
 ble.b hardc01                  * nein
 tst.b gdpcol(a5)               * FarbGDP?
 bne carset                     * Ja, dann Abbruch
hardc01:
 move d0,d7                     * d7 wird zerstrt
 and #$f,d7                     * d0 bestimmt das Unterprogramm
 add d7,d7
 move hardctab(pc,d7.w),d7
 jmp hardctab(pc,d7)            * Unterprogramm anspringen

hardctab:                       * Adresstabelle der Unterprogramme
 dc.w relmaus-hardctab          * d0 = %00000000 Maus relativ
 dc.w absmaus-hardctab          * d0 = %00000001 Maus absolut
 dc.w mausaus-hardctab          * d0 = %00000010 Maus rcksetzen
 dc.w setkreuz-hardctab         * d0 = %00000011 Fadenkreuz setzen
 dc.w erakreuz-hardctab         * d0 = %00000100 Fadenkreuz lschen
 dc.w bewkreuz-hardctab         * d0 = %00000101 Fadenkreuz mir Maus steuern
 dc.w getadw-hardctab           * d0 = %00000110 Wert vom Analog-Digital-Wandler
 dc.w putcopy-hardctab          * d0 = %X0000111 Copy bei Ci an oder aus
                                * X = Spezialbit
 dc.w ramcopy-hardctab          * d0 = %XXXX1000 Bildschirm in Speicher
 dc.w ladbild-hardctab          * d0 = %XXXX1001 Speicher auf Bildschirm
 dc.w copy8-hardctab            * d0 = %XXXX1010 Hardcopy auf Drucker 8 Nadeln
 dc.w copy24-hardctab           * d0 = %XXXX1011 Hardcopy auf Drucker 24 Nadeln
 dc.w stdruck8-hardctab         * d0 = %XXXX1100 Standarthardcopy 8 Nalden
 dc.w stdruck24-hardctab        * d0 = %XXXX1101 Standarthardcopy 24 Nadeln
 dc.w druck8-hardctab           * d0 = %00001110 Speicher auf Drucker 8 Nadeln
 dc.w druck24-hardctab          * d0 = %00001111 Speicher auf Drucker 24 Nadeln

relmaus:                        * d0 = Tastencode
 clr d1                         * d1 = Schritte in X-Richtung
 clr d2                         * d2 = Schritte in Y-Richtung

absmaus:                        * d1, d2 enthalten letzte Position der Maus
jmp mausadr1(a5)

absmaus0:                       * Wenn Default-Maus angesprochen werden soll
 clr.b hardclat.w               * d0 enthlt danach Tastencode
 clr.b hardcclr.w               * d1 und d2 enthalten die neue Position
 move.b mrechts.w,d0
 sub.b mlinks.w,d0              * Schritte in X-Richtung
 ext d0
 add d0,d1                      * Auf letzten Wert addiert
 move.b mauf.w,d0
 sub.b mab.w,d0                 * Schritte in Y-Richtung
 ext d0
 add d0,d2                      * Auf letzten Wert addiert
 moveq #0,d0                    * Langwort gltig
 move.b mtast.w,d0              * Maustasten lesen
rts

mausaus:                        * Maus Register auf Null setzen
 jmp mausadr0(a5)

mausaus0:                       * Rcksprung von mausadr0
 clr.b hardcclr.w               * Zhler auf Null
rts

bewkreuz:                       * Kreuz mit Maus bewegen
 bsr.s absmaus                  * Absoluten Wert holen
 tst    d1                      * d1 und d2 werden auf den Bildschirmbereich
 bpl.s  bewk0                   * angepasst
 clr    d1
bra.s   bewk1
bewk0:
 cmp    #512,d1
 bmi.s  bewk1
 move   #511,d1
bewk1:
 tst    d2
 bpl.s  bewk2
 clr    d2
bra.s   setkreuz
bewk2:
 cmp    #256,d2
 bmi.s  setkreuz
 move   #255,d2
setkreuz:                       * d1, d2 Enthalten Position des Kreuzes
 move d0,-(a7)                  * Keine Randabfrage
 move.b ioflag(a5),d0
 and #1,d0
 neg d0                         * Bei neuer GDP sind die Pixel um 1 verschoben
 add #-1-191,d0
 sub d1,d0
 move.b d0,kreuzlx.w
 ror #8,d0
 move.b d0,kreuzhx.w            * X-Position Kreuz bertragen
 move #-257,d0
 add d2,d0
 move.b d0,kreuzly.w
 ror #8,d0
 move.b d0,kreuzhy.w            * Y-Position Kreuz bertragem
 move (a7)+,d0
rts

erakreuz:                       * Kreuz wird ausgeblendet
 clr.b kreuzlx.w
 clr.b kreuzhx.w
 clr.b kreuzly.w
 clr.b kreuzhy.w                * Alle Werte auf Null setzen
rts

getadw:                         * Wert vom AD-Wandler nach d0.b d0.l gltig
 moveq #0,d0                    * Langwort gltig
 move.b hardcad8.w,d0           * Wert holen
rts

putcopy:                        * Bit 7 = 0 Keine Copy
 and.b #$80,d0                  * Bit 7 = 1 Mit Copy
 lsr.b #1,d0                    * Bit 7 nach Bit 6
 and.b #%10111111,menflag(a5)   * Bit 6 bei menflag lschen
 or.b d0,menflag(a5)            * Bit einfgen
rts

ramcopy:                        * a0 zeigt auf Speicherplatz
 move d0,d7
 and.b #$f0,d7                  * Mit Extrafunktion ?
 bne.s ramcopy0                 * Ja, dann weiter
 btst.b #0,ioflag(a5)           * Neue GDP ?
 beq.s ramcopy0                 * Nein, dann keine schnelle Hardcopy
 move.l a6,-(a7)                * a6 retten, da im Grafikpaket zerstrt
 bsr gr1p20                     * Schnelle Hardcopy
 movea.l (a7)+,a6               * a6 zurck
rts
ramcopy0:
 movem.l d1-d6/a0-a1,-(a7)      * d0 ist Spezialcode
 move.b #$fe,kreuzly.w          * Bit 4 = Spiegelung an Y=128
 move.b #$ff,kreuzhy.w          * Bit 5 = Spiegelung an X=256
 moveq #63,d1                   * Bit 6 = Invers
ramcopya:                       * Bit 7 = Einsetzen
 moveq #-1,d7
 moveq #63,d2
 sub d1,d2                      * Rechts nach Links
 btst #5,d0
 beq.s ramcopyb
 moveq #1,d7                    * Links nach Rechts
 move d1,d2
ramcopyb:
 lsl #3,d2                      * Mal 8, da 8 Bits pro Zeile geholt werden
 move.b ioflag(a5),d5
 and.b #1,d5
 add.b d5,d2                    * Bei neuer GDP sind die Pixel um 1 verschoben
 neg d2
 sub #192,d2                    * Position des Kreuzes berechnet
 moveq #8-1,d3                  * 8 Punkte pro Durchgang
ramcopyc:
 lea -356(a7),a1                * Ablageadresse
 move d2,d5
 move.b d5,kreuzlx.w
 ror #8,d5
 move.b d5,kreuzhx.w            * X-Position des Kreuzes setzen
 move #256-1,d4                 * 256 Zeilen
ramcopyd:
 tst.b hardclat.w               * Ready-Flag lschen
 move.b (a1),d6                 * Altes Byte holen
ramcopye:
 move.b kreuzhy.w,d5            * Warten bis Punkt gefunden
 bpl.s ramcopye
 lsl.b #2,d5                    * Bildpunkt ins X-Flag schieben
 roxl.b #1,d6                   * Bit einfgen
 move.b d6,(a1)+                * Und ablegen von Oben nach Unten
dbra d4,ramcopyd                * Nchstes Zeile
 add d7,d2
dbra d3,ramcopyc                * Nchste Spalte
 lea -356(a7),a1
 moveq #1,d3                    * Von Oben nach Unten
 btst.b #4,d0
 beq.s ramcopyf
 moveq #-1,d3                   * Von Unten nach Oben
 adda #255,a1
ramcopyf:
 move #256-1,d2                 * 256 Bytes
ramcopyg:
 move.b (a1),d4                 * Byte holen
 adda.l d3,a1                   * Von Oben nach Unten oder umgekehrt
 btst.b #6,d0
 bne.s ramcopyh
 not.b d4                       * Invers
ramcopyh:
 tst.b d0
 bmi.s ramcopyi                 * Bit 7 gesetzt, dann odern
 move.b d4,(a0)                 * Sonst ins Speicherfeld setzen
bra.s ramcopyj
ramcopyi:
 or.b d4,(a0)                   * Odern
ramcopyj:
 adda #64,a0                    * Nchste Adresse
dbra d2,ramcopyg
 suba #64*256-1,a0              * a0 wieder reparieren
dbra d1,ramcopya
 movem.l (a7)+,d1-d6/a0-a1
bra erakreuz                    * Kreuz ausschalten

ladbild:                        * d0 ist Extracode wie bei Ramcopy
 movem.l d0-d6/a0-a2,-(a7)      * Bit 7 hier XOR-Mode
 move.b xormode(a5),-(a7)       * Funktioniert nur mit erweiterter GDP-Karte
 move.b d0,d7
 rol.b #1,d0                    * Bit fr XOR-Mode an richtige Stelle
 and.b #1,d0                    * Nur an oder aus erlaubt
 move.b d0,xormode(a5)          * XOR merken fr aktpage
 bsr aktpage                    * Seite einstellen, dabei Color und XOR setzen
 lea gdp.w,a1                   * GDP-Basis fr WAIT
 lea gdp+$9*cpu.w,a2            * X-Low
 clr.b gdp+$a*cpu.w             * Y-High immer auf Null, da nicht grer als 255
 move #$01ff,d3                 * Anfang links
 moveq #1,d1                    * Richtung positiv
 btst.b #5,d7                   * Spiegelung X ?
 beq.s ladbild0
 moveq #0,d3                    * Anfang rechts
 moveq #-1,d1                   * Richtung negativ
ladbild0:
 move d3,d4
 lsr #8,d4                      * X-High
 move.b d4,gdp+$8*cpu.w
 moveq #0,d4                    * Anfang oben
 moveq #-1,d2                   * Richtung negativ
 btst.b #4,d7                   * Spiegelung Y ?
 beq.s ladbild1
 moveq #-1,d4                   * Anfang unten
 moveq #1,d2                    * Richtung positiv
ladbild1:
 lsl #2,d7                      * Invers Bit jetzt Bit 8
 move.b d3,d7                   * X-Low nach d7
 move.b d4,gdp+$b*cpu.w         * Y-Low
 move #256-1,d3                 * 256 Reihen
ladbild2:
 btst.b #2,(a1)                 * Warten
 beq.s ladbild2
 add.b d2,gdp+$b*cpu.w          * Eine Reihe weiter
 moveq #2-1,d4                  * X geteilt in zwei Hlften wegen 256-Grenze
ladbild3:
 btst.b #2,(a1)                 * Warten
 beq.s ladbild3
 eori.b #1,gdp+$8*cpu.w         * Hlfte ndern
 moveq #8-1,d5                  * 8*32*2 = 512
ladbild4:
 move.l (a0)+,d0                * 32 Pixel
 btst #8,d7
 beq.s ladbild5                 * Invers  ?
 not.l d0                       * Ja
ladbild5:
 moveq #32-1,d6                 * 32 Bits
ladbild6:
 add.b d1,d7
 btst.b d6,d0                   * Test, ob Punkt gesetzt
 beq.s ladbild8
ladbild7:
 btst.b #2,(a1)                 * Warten
 beq.s ladbild7
 move.b d7,(a2)                 * Neue X-Koordinate
 move.b #$80,(a1)               * Punkte setzen
ladbild8:
dbra d6,ladbild6
dbra d5,ladbild4
dbra d4,ladbild3
dbra d3,ladbild2
 move.b (a7)+,xormode(a5)       * XOR-Mode zurck
 bsr aktpage                    * Seite und xormode einstellen
 movem.l (a7)+,d0-d6/a0-a2      * Register zurck
rts

nad8tab:                        * Tabelle fr den Grafikdruck mit 8 Nadeln
 dc.b $1b,'<'                   * Unidirektionaler Druck fr eine Zeile
 dc.b $1b,'A',8                 * Zeilenvorschub auf 8/60 Zoll
 dc.b $1b,'L',0,2               * 8-Punkt-Grafik doppelte Punktdichte
 dc.b $ff                       * Keine Vergrerung

stdruck8:                       * Hier nur d0 / a0 vorbelegen
 lea nad8tab(pc),a1             * Ausdruck auf RX80-kompatiblen Drucker 8 Nadeln
 bsr.s copy8                    * Ausdruck aufrufen
stdrucka:
 moveq #$1b,d0                  * Zeilenabstand wieder einstellen
 bsr lo2
 moveq #'2',d0                  * auf 1/6 Zoll
bra lo2

copy8:                          * d0 = Kennung wie bei Ramcopy
 bsr ramcopy                    * wenn aus Bildspeicher gedruckt wird
druck8:                         * sonst einfach Ausdruck aus Speicher ohne d0
 movem.l d0-d6/a2-a4/a6,-(a7)
 movea #8-1,a3                  * 8 Bits pro Zeile (9 Nadeln)
 lea druck8a(pc),a4             * Adresse Ausgaberoutine
 bsr.s drucke                   * Ausgabe
 movem.l (a7)+,d0-d6/a2-a4/a6
rts

druck8a:                        * Ausgabe mit Vergrerung X fr 9 Nadeln
 bsr lo2
dbra d2,druck8a
rts

nad24tab:                       * Druckerbefehle fr 24 Nadel-Drucker
 dc.b $1b,'<'                   * Unidirektionaler Druck fr eine Zeile
 dc.b $1b,'A',8                 * Zeilenvorschub 8/60 Zoll
 dc.b $1b,'*',40,0,10           * 24 Nadeln sechsfache Dichte
 dc.b %10110011                 * Vergrerung 4 fr X und Y
 ds 0

stdruck24:                      * Ausdruck mit 24 Nadeln, Werte wie stdruck8
 lea nad24tab(pc),a1            * Adresse Druckerbefehle
 bsr.s copy24
bra.s stdrucka                  * Zeilenabstand wieder einstellen

copy24:                         * d0 = Kennung wie bei Ramcopy
 bsr ramcopy                    * wenn aus Bildspeicher gedruckt wird
druck24:                        * sonst einfach Ausdruck aus Speicher ohne d0
 movem.l d0-d6/a2-a4/a6,-(a7)
 movea #24-1,a3                 * 24 Bits pro Zeile (24 Nadeln)
 lea druck24a(pc),a4            * Adresse Ausgaberoutine
 bsr.s drucke                   * Ausgabe
 movem.l (a7)+,d0-d6/a2-a4/a6
rts

druck24a:                       * Ausgabe mit Vergrerung X fr 24 Nadeln
 swap d0
 bsr lo2                        * Erstes Byte
 swap d0
 rol #8,d0
 bsr lo2                        * Zweites Byte
 rol #8,d0
 bsr lo2                        * Drittes Byte
dbra d2,druck24a
rts

drucke:                         * a0 = Rambereich, a1 = Druckerbefehle
 movea.l a1,a2                  * a3 = Anzahl Bits pro Zeile, a4 = Druckroutine
druckea:
 move.b (a2)+,d0
 bpl.s druckea                  * Endekennung suchen
 move d0,d4
 lsr #4,d4
 and #$7,d4                     * Nur %xxx brig lassen
 cmp #$7,d4
 bne.s druckeb
 moveq #-1,d4
druckeb:
 addq #1,d4                     * Bereich 0 bis 7 (Fr Vergrerung 1 bis 8)
 and #$7,d0                     * Nur %yyy brig lassen
 cmp #$7,d0
 bne.s druckec
 moveq #-1,d0
druckec:
 addq #2,d0                     * Bereich 1 bis 8 (Fr Vergrerung 1 bis 8)
 move.l #840,d3
 divu d0,d3
 moveq #0,d7                    * Zeilenzhler
drucked:
 movea.l a1,a2
druckee:
 move.b (a2)+,d0                * Zeileninitialisierung
 bmi.s druckef
 bsr lo2
bra.s druckee
druckef:
 movea.l a0,a2
 moveq #64-1,d6                 * Anzahl Bytes pro Zeile
druckeg:
 moveq #8-1,d5                  * Anzahl Bits pro Byte
druckeh:
 move a3,d2
 movea.l d7,a6
 moveq #0,d0                    * Alle Bits auf Null
druckei:
 lsl.l #1,d0                    * Weiterschieben
 move.l a6,d1
 divu #840,d1
 cmp #256,d1
 beq.s druckek                  * Auerhalb des Bildschirms
 asl #6,d1                      * Zeilenadresse berechnet
 btst.b d5,0(a2,d1.w)
 beq.s druckej                  * Bit nicht gesetzt, dehalb weiter
 addq #1,d0                     * Bit setzen
druckej:
 adda d3,a6                     * Nchste Zeile
druckek:
dbra d2,druckei
 move d4,d2                     * Vergrerung X
 jsr (a4)
dbra d5,druckeh
 addq.l #1,a2
dbra d6,druckeg
 bsr locrlf                     * Zeilenvorschub
 move.l a6,d7                   * Neue Zeile
 cmp.l #256*840,d7
 bne.s drucked                  * Bis Ende erreicht
rts
                                                                                                                                                                                                                                                                                                                                                           